%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, Feb 12th, 2015, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = Separated_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx,Kf,H,G,M,L)
Z = xx(1:4);
X = xx(5:6);

global Ints_u Ints_yy2 Ints_ts Ints_count Ints_tmp Ints_hatfa  Ints_hatd


d = 2*sin(2*pi*t); % disturbance
fa = f(t); % fault
xd = 1; % output tracking reference

%controller
X = X - [xd; 0];
y = C*X + D2*d + [1;1]*noise(t);
hat_x = Z + H*y;
K = [Kx Kf];
u = K * hat_x(1:3);

%observer
bar_B = [B;zeros(2,1)];
GB = G*bar_B;
dot_Z = M*Z + GB*u + L*y;


% sys dynamic
dot_X = A*X + B*u + F*fa + D1*d;
y0 = y - D2*hat_x(4);

% data saving 
if mod(Ints_tmp,6)==0
    Ints_count = Ints_count + 1;
Ints_ts(Ints_count) = t;
Ints_u(Ints_count) = u;
Ints_yy2(Ints_count) = y0(2);
Ints_hatfa(Ints_count) = fa - hat_x(3);
Ints_hatd(Ints_count) = d - hat_x(4);
end
Ints_tmp = Ints_tmp + 1;
sys_state = [dot_Z;dot_X];